/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.command;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.attribute.IAttribute;
import dev.toma.gunsrpg.api.common.attribute.IAttributeId;
import dev.toma.gunsrpg.api.common.attribute.IAttributeModifier;
import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.data.IDebuffs;
import dev.toma.gunsrpg.api.common.data.IKillData;
import dev.toma.gunsrpg.api.common.data.ILockStateChangeable;
import dev.toma.gunsrpg.api.common.data.IPerkProvider;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.IPointProvider;
import dev.toma.gunsrpg.api.common.data.IQuests;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.api.common.skill.ISkillHierarchy;
import dev.toma.gunsrpg.api.common.skill.ITransactionValidator;
import dev.toma.gunsrpg.common.attribute.Attribs;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.command.JsonArgumentType;
import dev.toma.gunsrpg.common.debuffs.IDebuffType;
import dev.toma.gunsrpg.common.entity.AirdropEntity;
import dev.toma.gunsrpg.common.init.ModRegistries;
import dev.toma.gunsrpg.common.item.guns.setup.AbstractGun;
import dev.toma.gunsrpg.common.item.perk.Crystal;
import dev.toma.gunsrpg.common.item.perk.CrystalAttribute;
import dev.toma.gunsrpg.common.item.perk.CrystalItem;
import dev.toma.gunsrpg.common.perk.Perk;
import dev.toma.gunsrpg.common.perk.PerkRegistry;
import dev.toma.gunsrpg.common.perk.PerkType;
import dev.toma.gunsrpg.common.quests.QuestSystem;
import dev.toma.gunsrpg.common.quests.condition.IQuestConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.list.WeightedConditionList;
import dev.toma.gunsrpg.common.quests.quest.DisplayInfo;
import dev.toma.gunsrpg.common.quests.quest.IQuestData;
import dev.toma.gunsrpg.common.quests.quest.Quest;
import dev.toma.gunsrpg.common.quests.quest.QuestConditionTierScheme;
import dev.toma.gunsrpg.common.quests.quest.QuestManager;
import dev.toma.gunsrpg.common.quests.quest.QuestScheme;
import dev.toma.gunsrpg.common.quests.quest.QuestStatus;
import dev.toma.gunsrpg.common.quests.quest.QuestType;
import dev.toma.gunsrpg.common.quests.reward.IQuestItemProvider;
import dev.toma.gunsrpg.common.quests.reward.QuestReward;
import dev.toma.gunsrpg.common.quests.reward.QuestRewardList;
import dev.toma.gunsrpg.common.quests.reward.QuestRewardManager;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.common.skills.core.TransactionValidatorRegistry;
import dev.toma.gunsrpg.util.helper.CommandHelper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.server.command.EnumArgument;

public class GunsrpgCommand {
    private static final SuggestionProvider<CommandSource> DEBUFF_SUGGESTION = (context, builder) -> ISuggestionProvider.func_197014_a((Iterable)ModRegistries.DEBUFFS.getValues().stream().filter(IDebuffType::isToggleable).map(ForgeRegistryEntry::getRegistryName).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSource> TX_VALIDATOR_SUGGESTION = (context, builder) -> ISuggestionProvider.func_197014_a(TransactionValidatorRegistry.getRegisteredValidatorTypes(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSource> SKILL_SUGGESTION = (context, builder) -> ISuggestionProvider.func_197014_a((Iterable)ModRegistries.SKILLS.getKeys(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSource> ATTRIBUTE_SUGGESTION = (context, builder) -> ISuggestionProvider.func_197014_a(Attribs.listKeys(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSource> PERK_SUGGESTION = (context, builder) -> ISuggestionProvider.func_197014_a(PerkRegistry.getRegistry().getPerkIds(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSource> QUEST_SUGGESTION = (context, builder) -> ISuggestionProvider.func_197014_a(GunsRPG.getModLifecycle().quests().getQuestManager().getQuestIds(), (SuggestionsBuilder)builder);
    private static final SimpleCommandExceptionType NO_DATA = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.gunsrpg.exception.no_data"));
    private static final SimpleCommandExceptionType MISSING_KEY_EXCEPTION = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.gunsrpg.exception.missing_key"));
    private static final DynamicCommandExceptionType MISSING_ARGUMENTS = new DynamicCommandExceptionType(o -> new TranslationTextComponent("command.gunsrpg.exception.missing_args", new Object[]{o}));
    private static final SimpleCommandExceptionType LOCATION_OBSTRUCTED = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.gunsrpg.exception.location_obstructed"));
    private static final DynamicCommandExceptionType UNKNOWN_KEY_EXCEPTION = new DynamicCommandExceptionType(data -> new TranslationTextComponent("command.gunsrpg.exception.unknown_key", new Object[]{data}));
    private static final SimpleCommandExceptionType INVALID_TX_DATA = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.gunsrpg.exception.invalid_tx_data"));
    private static final DynamicCommandExceptionType REQUIRED_SKILL = new DynamicCommandExceptionType(id -> new TranslationTextComponent("command.gunsrpg.exception.missing_skill", new Object[]{id}));
    private static final DynamicCommandExceptionType DEPENDENT_SKILL_ACTIVE = new DynamicCommandExceptionType(id -> new TranslationTextComponent("command.gunsrpg.exception.active_skill", new Object[]{id}));
    private static final SimpleCommandExceptionType NOT_HOLDING_CRYSTAL = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.gunsrpg.exception.not_holding_crystal"));
    private static final SimpleCommandExceptionType NO_ACTIVE_QUEST = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.gunsrpg.exception.no_quest"));
    private static final SimpleCommandExceptionType NOT_HOLDING_GUN = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.gunsrpg.exception.not_holding_gun"));

    public static void registerCommandTree(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"gunsrpg").requires(src -> src.func_197034_c(2) && src.func_197022_f() instanceof PlayerEntity)).then(Commands.func_197057_a((String)"debuff").then(Commands.func_197056_a((String)"registryKey", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(DEBUFF_SUGGESTION).executes(GunsrpgCommand::toggleDebuff)))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"event").then(Commands.func_197057_a((String)"bloodmoon").executes(GunsrpgCommand::forceBloodmoon))).then(Commands.func_197057_a((String)"airdrop").executes(GunsrpgCommand::callAirdrop)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"progression").then(Commands.func_197057_a((String)"reset").executes(ctx -> GunsrpgCommand.forceProgression((CommandContext<CommandSource>)ctx, ModifyAction.LOCK)))).then(Commands.func_197057_a((String)"unlockAll").executes(ctx -> GunsrpgCommand.forceProgression((CommandContext<CommandSource>)ctx, ModifyAction.UNLOCK)))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"txType", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(TX_VALIDATOR_SUGGESTION).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"level").executes(GunsrpgCommand::addLevel)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(GunsrpgCommand::addLevels)).then(Commands.func_197056_a((String)"txData", (ArgumentType)JsonArgumentType.json()).executes(GunsrpgCommand::addLevelsSpecific))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"point").executes(GunsrpgCommand::addPoint)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(GunsrpgCommand::addPoints)).then(Commands.func_197056_a((String)"txData", (ArgumentType)JsonArgumentType.json()).executes(GunsrpgCommand::addPointsSpecific))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"progress").executes(ctx -> GunsrpgCommand.progressAdd((CommandContext<CommandSource>)ctx, 1, null))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> GunsrpgCommand.progressAdd((CommandContext<CommandSource>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), null))).then(Commands.func_197056_a((String)"txData", (ArgumentType)JsonArgumentType.json()).executes(ctx -> GunsrpgCommand.progressAdd((CommandContext<CommandSource>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), JsonArgumentType.getJson(ctx, "txData"))))))).executes(ctx -> GunsrpgCommand.noArgsProvided("level", "point", "progress")))).executes(ctx -> GunsrpgCommand.noArgsProvided("reset", "unlockAll")))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"skill").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"skillId", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SKILL_SUGGESTION).then(Commands.func_197057_a((String)"unlock").executes(GunsrpgCommand::unlockSkill))).then(Commands.func_197057_a((String)"lock").executes(GunsrpgCommand::lockSkill))).executes(ctx -> GunsrpgCommand.noArgsProvided("unlock", "lock")))).executes(ctx -> {
            throw MISSING_KEY_EXCEPTION.create();
        }))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"attribute").executes(ctx -> GunsrpgCommand.noArgsProvided("id"))).then(Commands.func_197056_a((String)"id", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(ATTRIBUTE_SUGGESTION).executes(GunsrpgCommand::listAttributeInfo)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"crystal").executes(ctx -> GunsrpgCommand.noArgsProvided("id", "level", "generate"))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"perk", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(PERK_SUGGESTION).executes(ctx -> GunsrpgCommand.noArgsProvided("add", "remove"))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").executes(ctx -> GunsrpgCommand.editCrystal((CommandContext<CommandSource>)ctx, ModifyAction.UNLOCK, 1))).then(Commands.func_197056_a((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> GunsrpgCommand.editCrystal((CommandContext<CommandSource>)ctx, ModifyAction.UNLOCK, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level")))))).then(Commands.func_197057_a((String)"remove").executes(ctx -> GunsrpgCommand.editCrystal((CommandContext<CommandSource>)ctx, ModifyAction.LOCK, 0))))).then(Commands.func_197056_a((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(GunsrpgCommand::editCrystalLevel))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"generate").executes(GunsrpgCommand::generateCrystalFromConfig)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(GunsrpgCommand::generateCrystalFromCustomConfig)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"buffs", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(GunsrpgCommand::generateCrystalFromCustomConfig)).then(Commands.func_197056_a((String)"debuffs", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(GunsrpgCommand::generateCrystalFromCustomConfig)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"cooldown").executes(ctx -> GunsrpgCommand.noArgsProvided("cooldownValue"))).then(Commands.func_197056_a((String)"cooldownValue", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(GunsrpgCommand::setCrystalUsageCooldown))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"quest").executes(ctx -> GunsrpgCommand.noArgsProvided("reward"))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"reward").executes(ctx -> GunsrpgCommand.addRandomReward((CommandContext<CommandSource>)ctx, 1, 1, true))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)1, (int)8)).executes(ctx -> GunsrpgCommand.addRandomReward((CommandContext<CommandSource>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"tier"), 1, true))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"itemCount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(ctx -> GunsrpgCommand.addRandomReward((CommandContext<CommandSource>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"tier"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"itemCount"), true))).then(Commands.func_197056_a((String)"setUnique", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> GunsrpgCommand.addRandomReward((CommandContext<CommandSource>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"tier"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"itemCount"), BoolArgumentType.getBool((CommandContext)ctx, (String)"setUnique")))))).then(Commands.func_197057_a((String)"list").executes(GunsrpgCommand::listTierRewardPool))))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"questId", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(QUEST_SUGGESTION).executes(GunsrpgCommand::listQuestInfo)).then(Commands.func_197057_a((String)"start").executes(GunsrpgCommand::startNewQuest)))).then(Commands.func_197057_a((String)"cancel").executes(GunsrpgCommand::cancelCurrectQuest))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"changeStatus").executes(ctx -> GunsrpgCommand.noArgsProvided("status"))).then(Commands.func_197056_a((String)"status", (ArgumentType)EnumArgument.enumArgument(QuestStatus.class)).executes(GunsrpgCommand::updateQuestStatus))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"weapon").executes(ctx -> GunsrpgCommand.noArgsProvided("force_jam"))).then(Commands.func_197057_a((String)"force_jam").executes(GunsrpgCommand::jamWeapon)))).executes(ctx -> GunsrpgCommand.noArgsProvided("debuff", "event", "progression", "skill")));
    }

    private static int jamWeapon(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Entity executor = ((CommandSource)context.getSource()).func_197022_f();
        if (!(executor instanceof PlayerEntity)) {
            return -1;
        }
        PlayerEntity player = (PlayerEntity)executor;
        ItemStack stack = player.func_184614_ca();
        if (!(stack.func_77973_b() instanceof AbstractGun)) {
            throw NOT_HOLDING_GUN.create();
        }
        AbstractGun gun = (AbstractGun)stack.func_77973_b();
        gun.setJammedState(stack, true);
        return 0;
    }

    private static int setCrystalUsageCooldown(CommandContext<CommandSource> context) {
        int value = IntegerArgumentType.getInteger(context, (String)"cooldownValue");
        Entity executor = ((CommandSource)context.getSource()).func_197022_f();
        if (!(executor instanceof PlayerEntity)) {
            return -1;
        }
        PlayerEntity player = (PlayerEntity)executor;
        IPlayerData data = PlayerData.getUnsafe(player);
        IPerkProvider provider = data.getPerkProvider();
        provider.setCooldown(value);
        return 0;
    }

    private static int startNewQuest(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Entity executor = ((CommandSource)context.getSource()).func_197022_f();
        if (!(executor instanceof PlayerEntity)) {
            return -1;
        }
        PlayerEntity player = (PlayerEntity)executor;
        IPlayerData data = PlayerData.getUnsafe(player);
        ResourceLocation location = ResourceLocationArgument.func_197195_e(context, (String)"questId");
        QuestSystem system = GunsRPG.getModLifecycle().quests();
        QuestManager manager = system.getQuestManager();
        QuestScheme scheme = manager.getScheme(location);
        if (scheme == null) {
            throw UNKNOWN_KEY_EXCEPTION.create((Object)location);
        }
        Quest quest = GunsrpgCommand.newQuest(scheme);
        IQuests provider = data.getQuests();
        quest.setStatus(QuestStatus.ACTIVE);
        provider.assignQuest(quest);
        quest.assign(player);
        return 0;
    }

    private static <D extends IQuestData, Q extends Quest<D>> Quest<D> newQuest(QuestScheme<D> scheme) {
        QuestType<D, ?> type = scheme.getQuestType();
        return type.newQuestInstance(scheme, Util.field_240973_b_);
    }

    private static int updateQuestStatus(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Entity executor = ((CommandSource)context.getSource()).func_197022_f();
        if (!(executor instanceof PlayerEntity)) {
            return -1;
        }
        PlayerEntity player = (PlayerEntity)executor;
        IPlayerData data = PlayerData.getUnsafe(player);
        Optional<Quest<?>> optional = data.getQuests().getActiveQuest();
        if (!optional.isPresent()) {
            throw NO_ACTIVE_QUEST.create();
        }
        QuestStatus status = (QuestStatus)((Object)context.getArgument("status", QuestStatus.class));
        optional.get().setStatus(status);
        data.sync(4);
        return 0;
    }

    private static int cancelCurrectQuest(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Entity executor = ((CommandSource)context.getSource()).func_197022_f();
        if (!(executor instanceof PlayerEntity)) {
            return -1;
        }
        PlayerEntity player = (PlayerEntity)executor;
        IPlayerData data = PlayerData.getUnsafe(player);
        Optional<Quest<?>> optional = data.getQuests().getActiveQuest();
        if (!optional.isPresent()) {
            throw NO_ACTIVE_QUEST.create();
        }
        data.getQuests().clearActiveQuest();
        return 0;
    }

    private static int listQuestInfo(CommandContext<CommandSource> context) throws CommandSyntaxException {
        QuestConditionTierScheme.TieredList[] tieredLists;
        Entity executor = ((CommandSource)context.getSource()).func_197022_f();
        if (!(executor instanceof PlayerEntity)) {
            return -1;
        }
        PlayerEntity player = (PlayerEntity)executor;
        ResourceLocation questId = ResourceLocationArgument.func_197195_e(context, (String)"questId");
        QuestSystem system = GunsRPG.getModLifecycle().quests();
        QuestScheme scheme = system.getQuestManager().getScheme(questId);
        if (scheme == null) {
            throw UNKNOWN_KEY_EXCEPTION.create((Object)questId);
        }
        QuestType questType = scheme.getQuestType();
        Object data = scheme.getData();
        DisplayInfo info = scheme.getDisplayInfo();
        QuestConditionTierScheme tierScheme = scheme.getConditionTierScheme();
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.YELLOW.toString() + TextFormatting.BOLD + "Quest: " + TextFormatting.RESET + TextFormatting.YELLOW + scheme.getQuestId()), Util.field_240973_b_);
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Type of quest: " + TextFormatting.AQUA + questType.getId()), Util.field_240973_b_);
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Tier: " + TextFormatting.AQUA + scheme.getTier()), Util.field_240973_b_);
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Data: " + TextFormatting.AQUA + data.toString()), Util.field_240973_b_);
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.YELLOW.toString() + TextFormatting.BOLD + "Display info"), Util.field_240973_b_);
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Name: " + TextFormatting.AQUA + info.getName().getString()), Util.field_240973_b_);
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Info: " + TextFormatting.AQUA + info.getInfo().getString()), Util.field_240973_b_);
        IQuestConditionProvider<?>[] questConditions = scheme.getQuestConditions();
        if (questConditions.length > 0) {
            player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.YELLOW.toString() + TextFormatting.BOLD + "Conditions"), Util.field_240973_b_);
            for (IQuestConditionProvider<?> provider : questConditions) {
                Object condition = provider.makeConditionInstance();
                ITextComponent text = condition.getDescriptor(false);
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "- " + TextFormatting.AQUA + text.getString()), Util.field_240973_b_);
            }
        }
        if ((tieredLists = tierScheme.getListProviders()).length > 0) {
            player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.YELLOW.toString() + TextFormatting.BOLD + "Tiered conditions"), Util.field_240973_b_);
            for (QuestConditionTierScheme.TieredList list : tieredLists) {
                WeightedConditionList rawList = list.getListRaw();
                IQuestConditionProvider<?>[] providers = rawList.getProviders();
                int tierModifier = list.getTier();
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Added tier: " + TextFormatting.AQUA + tierModifier), Util.field_240973_b_);
                for (IQuestConditionProvider<?> provider : providers) {
                    Object condition = provider.makeConditionInstance();
                    ITextComponent textComponent = condition.getDescriptor(false);
                    player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "- " + TextFormatting.AQUA + textComponent.getString()), Util.field_240973_b_);
                }
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "-------------------------"), Util.field_240973_b_);
            }
        }
        return 0;
    }

    private static int listTierRewardPool(CommandContext<CommandSource> context) {
        Entity executor = ((CommandSource)context.getSource()).func_197022_f();
        if (!(executor instanceof PlayerEntity)) {
            return -1;
        }
        PlayerEntity player = (PlayerEntity)executor;
        int tier = CommandHelper.getArgumentOptional(context, "tier", IntegerArgumentType::getInteger).orElse(1);
        QuestSystem system = GunsRPG.getModLifecycle().quests();
        QuestRewardManager manager = system.getRewardManager();
        QuestRewardList list = manager.getTieredRewards(tier);
        IQuestItemProvider[] providers = list.listProviders();
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.YELLOW.toString() + TextFormatting.BOLD + "=========[ Tier " + tier + " items ]=========="), Util.field_240973_b_);
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Entries: " + TextFormatting.AQUA + providers.length), Util.field_240973_b_);
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Items:"), Util.field_240973_b_);
        for (IQuestItemProvider provider : providers) {
            IQuestItemProvider.Impl implementation = (IQuestItemProvider.Impl)provider;
            player.func_145747_a((ITextComponent)new StringTextComponent(String.format("%sItem: %s%s%s, Count: %s%d%s, Weight: %s%d", TextFormatting.GREEN, TextFormatting.AQUA, implementation.getItem().getRegistryName().func_110623_a(), TextFormatting.GREEN, TextFormatting.AQUA, implementation.getCount(), TextFormatting.GREEN, TextFormatting.AQUA, implementation.getWeight())), Util.field_240973_b_);
        }
        return 0;
    }

    private static int addRandomReward(CommandContext<CommandSource> context, int tier, int itemCount, boolean unique) {
        Entity executor = ((CommandSource)context.getSource()).func_197022_f();
        if (!(executor instanceof PlayerEntity)) {
            return -1;
        }
        PlayerEntity player = (PlayerEntity)executor;
        QuestSystem questSystem = GunsRPG.getModLifecycle().quests();
        QuestRewardManager manager = questSystem.getRewardManager();
        QuestRewardList list = manager.getTieredRewards(tier);
        QuestReward.Options options = new QuestReward.Options().items(itemCount);
        if (unique) {
            options = options.setUnique();
        }
        QuestReward reward = QuestReward.generate(list, options, player);
        for (QuestReward.Choice choice : reward.getChoices()) {
            choice.distributeToInventory(player);
        }
        return 0;
    }

    private static int generateCrystalFromConfig(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Entity executor = ((CommandSource)context.getSource()).func_197022_f();
        if (!(executor instanceof PlayerEntity)) {
            return -1;
        }
        PlayerEntity player = (PlayerEntity)executor;
        ItemStack crystalStack = player.func_184614_ca();
        if (!(crystalStack.func_77973_b() instanceof CrystalItem)) {
            throw NOT_HOLDING_CRYSTAL.create();
        }
        Crystal crystal = Crystal.generate();
        CrystalItem.addCrystal(crystalStack, crystal);
        return 0;
    }

    private static int generateCrystalFromCustomConfig(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Entity executor = ((CommandSource)context.getSource()).func_197022_f();
        if (!(executor instanceof PlayerEntity)) {
            return -1;
        }
        PlayerEntity player = (PlayerEntity)executor;
        ItemStack crystalStack = player.func_184614_ca();
        if (!(crystalStack.func_77973_b() instanceof CrystalItem)) {
            throw NOT_HOLDING_CRYSTAL.create();
        }
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        int buffs = CommandHelper.getArgumentOptional(context, "buffs", IntegerArgumentType::getInteger).orElse(1);
        int debuffs = CommandHelper.getArgumentOptional(context, "debuffs", IntegerArgumentType::getInteger).orElse(1);
        Crystal crystal = Crystal.generate(level, buffs, debuffs);
        CrystalItem.addCrystal(crystalStack, crystal);
        return 0;
    }

    private static int editCrystalLevel(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Entity executor = ((CommandSource)context.getSource()).func_197022_f();
        if (!(executor instanceof PlayerEntity)) {
            return -1;
        }
        PlayerEntity player = (PlayerEntity)executor;
        ItemStack crystalStack = player.func_184614_ca();
        if (!(crystalStack.func_77973_b() instanceof CrystalItem)) {
            throw NOT_HOLDING_CRYSTAL.create();
        }
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        CompoundNBT stackNbt = crystalStack.func_77978_p();
        if (stackNbt == null) {
            Crystal crystal = new Crystal(level, Collections.emptyList());
            CompoundNBT data = crystal.toNbt();
            CompoundNBT stackData = new CompoundNBT();
            stackData.func_218657_a("crystal", (INBT)data);
            crystalStack.func_77982_d(stackData);
        } else {
            Crystal crystal = Crystal.fromNbt(stackNbt.func_74775_l("crystal"));
            Crystal newCrystal = new Crystal(level, crystal.listAttributes());
            stackNbt.func_218657_a("crystal", (INBT)newCrystal.toNbt());
        }
        return 0;
    }

    private static int editCrystal(CommandContext<CommandSource> context, ModifyAction action, int level) throws CommandSyntaxException {
        ResourceLocation location = ResourceLocationArgument.func_197195_e(context, (String)"perk");
        Perk perk = PerkRegistry.getRegistry().getPerkById(location);
        if (perk == null) {
            throw UNKNOWN_KEY_EXCEPTION.create((Object)location);
        }
        Entity executor = ((CommandSource)context.getSource()).func_197022_f();
        if (!(executor instanceof PlayerEntity)) {
            return -1;
        }
        PlayerEntity player = (PlayerEntity)executor;
        ItemStack crystal = player.func_184614_ca();
        if (!(crystal.func_77973_b() instanceof CrystalItem)) {
            throw NOT_HOLDING_CRYSTAL.create();
        }
        switch (action) {
            case UNLOCK: {
                return GunsrpgCommand.addCrystalAttribute(perk, level, crystal);
            }
            case LOCK: {
                return GunsrpgCommand.removeCrystalAttribute(perk, crystal);
            }
        }
        return -1;
    }

    private static int addCrystalAttribute(Perk perk, int level, ItemStack stack) {
        CompoundNBT stackNbt = stack.func_77978_p();
        if (stackNbt == null) {
            stackNbt = new CompoundNBT();
        }
        Crystal crystal = Crystal.fromNbt(stackNbt.func_74775_l("crystal"));
        PerkType type = level < 0 ? PerkType.DEBUFF : PerkType.BUFF;
        CrystalAttribute attribute = new CrystalAttribute(perk, type, Math.max(1, Math.abs(level)));
        Crystal modified = crystal.append(attribute);
        stackNbt.func_218657_a("crystal", (INBT)modified.toNbt());
        stack.func_77982_d(stackNbt);
        return 0;
    }

    private static int removeCrystalAttribute(Perk perk, ItemStack stack) {
        CompoundNBT stackNbt = stack.func_77978_p();
        if (stackNbt == null) {
            return 0;
        }
        Crystal crystal = Crystal.fromNbt(stackNbt.func_74775_l("crystal"));
        CrystalAttribute attribute = new CrystalAttribute(perk, PerkType.BUFF, 1);
        Crystal modified = crystal.remove(attribute);
        stackNbt.func_218657_a("crystal", (INBT)modified.toNbt());
        return 0;
    }

    private static int listAttributeInfo(CommandContext<CommandSource> context) throws CommandSyntaxException {
        CommandSource source = (CommandSource)context.getSource();
        Entity executor = source.func_197022_f();
        if (!(executor instanceof PlayerEntity)) {
            return -1;
        }
        PlayerEntity player = (PlayerEntity)executor;
        IPlayerData data = (IPlayerData)PlayerData.get(player).orElseThrow(() -> ((SimpleCommandExceptionType)NO_DATA).create());
        IAttributeProvider provider = data.getAttributes();
        ResourceLocation id = ResourceLocationArgument.func_197195_e(context, (String)"id");
        IAttributeId attributeId = Attribs.find(id);
        if (attributeId == null) {
            throw UNKNOWN_KEY_EXCEPTION.create((Object)id);
        }
        IAttribute attribute = provider.getAttribute(attributeId);
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.YELLOW.toString() + TextFormatting.BOLD + "=========[ Attribute Info ]=========="), Util.field_240973_b_);
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Attribute: " + TextFormatting.AQUA + id), Util.field_240973_b_);
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Base value: " + TextFormatting.AQUA + attribute.getBaseValue()), Util.field_240973_b_);
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Value: " + TextFormatting.AQUA + attribute.value()), Util.field_240973_b_);
        List<IAttributeModifier> modifiers = attribute.listModifiers();
        int modifierCount = modifiers.size();
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Modifier count: " + TextFormatting.AQUA + modifierCount), Util.field_240973_b_);
        if (modifierCount > 0) {
            player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Modifiers:"), Util.field_240973_b_);
            for (IAttributeModifier modifier : modifiers) {
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "-" + TextFormatting.AQUA + modifier.toString()), Util.field_240973_b_);
            }
        }
        return 0;
    }

    private static int progressAdd(CommandContext<CommandSource> ctx, int amount, JsonElement data) throws CommandSyntaxException {
        return GunsrpgCommand.modifyProgression(ctx, amount, data, (killData, count) -> {
            for (int i = 0; i < count; ++i) {
                killData.advanceLevel(false);
            }
        });
    }

    private static int toggleDebuff(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ResourceLocation registryKey = ResourceLocationArgument.func_197195_e(ctx, (String)"registryKey");
        if (registryKey == null) {
            throw MISSING_KEY_EXCEPTION.create();
        }
        IDebuffType type = (IDebuffType)ModRegistries.DEBUFFS.getValue(registryKey);
        if (type == null || !type.isToggleable()) {
            throw UNKNOWN_KEY_EXCEPTION.create((Object)registryKey);
        }
        PlayerEntity player = GunsrpgCommand.getPlayer(ctx);
        LazyOptional<IPlayerData> optional = PlayerData.get(player);
        optional.ifPresent(data -> {
            IDebuffs debuffs = data.getDebuffControl();
            debuffs.toggle(type);
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.gunsrpg.toggle_debuff", new Object[]{type.getRegistryName().toString()}), false);
        });
        return 0;
    }

    private static int callAirdrop(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        CommandSource source = (CommandSource)ctx.getSource();
        ServerWorld world = source.func_197023_e();
        Entity entity = source.func_197022_f();
        if (entity == null) {
            return -1;
        }
        BlockPos pos = new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_() + 10.0, entity.func_226281_cx_());
        if (!world.func_175623_d(pos)) {
            throw LOCATION_OBSTRUCTED.create();
        }
        AirdropEntity airdrop = new AirdropEntity((World)world);
        airdrop.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        world.func_217376_c((Entity)airdrop);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.gunsrpg.airdrop"), false);
        return 0;
    }

    private static int forceBloodmoon(CommandContext<CommandSource> ctx) {
        CommandSource src = (CommandSource)ctx.getSource();
        MinecraftServer server = src.func_197028_i();
        IServerWorldInfo worldInfo = server.func_240793_aU_().func_230407_G_();
        long newGameTime = (long)GunsRPG.config.world.bloodmoonCycle * 24000L + 13000L;
        worldInfo.func_82572_b(newGameTime);
        src.func_197023_e().func_241114_a_(newGameTime);
        src.func_197030_a((ITextComponent)new TranslationTextComponent("command.gunsrpg.set_bloodmoon"), false);
        return 0;
    }

    private static int forceProgression(CommandContext<CommandSource> ctx, ModifyAction action) {
        CommandSource src = (CommandSource)ctx.getSource();
        PlayerEntity player = GunsrpgCommand.getPlayer(ctx);
        LazyOptional<IPlayerData> optional = PlayerData.get(player);
        optional.ifPresent(data -> {
            data.getSaveEntries().stream().filter(entry -> entry instanceof ILockStateChangeable).map(entry -> (ILockStateChangeable)((Object)entry)).forEach(action::apply);
            String translationKey = "command.gunsrpg.progression." + (action == ModifyAction.LOCK ? "reset" : "unlock");
            src.func_197030_a((ITextComponent)new TranslationTextComponent(translationKey), false);
            data.sync(-1);
        });
        return 0;
    }

    private static int addLevel(CommandContext<CommandSource> context) throws CommandSyntaxException {
        return GunsrpgCommand.modifyProgression(context, 1, (JsonElement)JsonNull.INSTANCE, IKillData::addLevels);
    }

    private static int addLevels(CommandContext<CommandSource> context) throws CommandSyntaxException {
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        return GunsrpgCommand.modifyProgression(context, amount, (JsonElement)JsonNull.INSTANCE, IKillData::addLevels);
    }

    private static int addLevelsSpecific(CommandContext<CommandSource> context) throws CommandSyntaxException {
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        JsonElement data = JsonArgumentType.getJson(context, "txData");
        return GunsrpgCommand.modifyProgression(context, amount, data, IKillData::addLevels);
    }

    private static int addPoint(CommandContext<CommandSource> context) throws CommandSyntaxException {
        return GunsrpgCommand.modifyProgression(context, 1, (JsonElement)JsonNull.INSTANCE, IPointProvider::awardPoints);
    }

    private static int addPoints(CommandContext<CommandSource> context) throws CommandSyntaxException {
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        return GunsrpgCommand.modifyProgression(context, amount, (JsonElement)JsonNull.INSTANCE, IPointProvider::awardPoints);
    }

    private static int addPointsSpecific(CommandContext<CommandSource> context) throws CommandSyntaxException {
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        JsonElement data = JsonArgumentType.getJson(context, "txData");
        return GunsrpgCommand.modifyProgression(context, amount, data, IPointProvider::awardPoints);
    }

    private static int modifyProgression(CommandContext<CommandSource> context, int amount, JsonElement jsonData, BiConsumer<IKillData, Integer> action) throws CommandSyntaxException {
        CommandSource source = (CommandSource)context.getSource();
        Entity executor = source.func_197022_f();
        if (executor instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)executor;
            LazyOptional<IPlayerData> optional = PlayerData.get(player);
            ITransactionValidator validator = GunsrpgCommand.getTxValidator(context, jsonData);
            optional.ifPresent(data -> {
                IKillData killData = validator.getData((IPlayerData)data);
                action.accept(killData, amount);
                source.func_197030_a((ITextComponent)new TranslationTextComponent("command.gunsrpg.progression.modify"), false);
                data.sync(-1);
            });
            return 0;
        }
        return -1;
    }

    private static int unlockSkill(CommandContext<CommandSource> context) throws CommandSyntaxException {
        return GunsrpgCommand.modifySkill(context, ModifyAction.UNLOCK);
    }

    private static int lockSkill(CommandContext<CommandSource> context) throws CommandSyntaxException {
        return GunsrpgCommand.modifySkill(context, ModifyAction.LOCK);
    }

    private static int modifySkill(CommandContext<CommandSource> context, ModifyAction action) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocationArgument.func_197195_e(context, (String)"skillId");
        if (id == null) {
            throw MISSING_KEY_EXCEPTION.create();
        }
        SkillType type = (SkillType)ModRegistries.SKILLS.getValue(id);
        if (type == null) {
            throw UNKNOWN_KEY_EXCEPTION.create((Object)id);
        }
        boolean isUnlockOp = action == ModifyAction.UNLOCK;
        Entity executor = ((CommandSource)context.getSource()).func_197022_f();
        if (executor instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)executor;
            IPlayerData data = PlayerData.getUnsafe(player);
            ISkillProvider provider = data.getSkillProvider();
            ISkillHierarchy hierarchy = type.getHierarchy();
            if (isUnlockOp) {
                SkillType<?> parent = hierarchy.getParent();
                if (parent != null && !provider.hasSkill(parent)) {
                    throw REQUIRED_SKILL.create((Object)parent.getRegistryName());
                }
                provider.unlock(type);
            } else {
                SkillType<?>[] children = hierarchy.getChildren();
                if (children != null && children.length > 0) {
                    for (SkillType<?> child : children) {
                        if (!provider.hasSkill(child)) continue;
                        throw DEPENDENT_SKILL_ACTIVE.create(child);
                    }
                }
                provider.lock(type);
            }
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.gunsrpg.skill." + (action == ModifyAction.UNLOCK ? "unlock" : "lock"), new Object[]{id}), false);
            return 0;
        }
        return -1;
    }

    private static ITransactionValidator getTxValidator(CommandContext<CommandSource> context, JsonElement data) throws CommandSyntaxException {
        Object validator;
        ResourceLocation id = ResourceLocationArgument.func_197195_e(context, (String)"txType");
        Object factory = TransactionValidatorRegistry.getValidatorFactory(id);
        if (factory == null) {
            throw UNKNOWN_KEY_EXCEPTION.create((Object)id);
        }
        try {
            validator = TransactionValidatorRegistry.getTransactionValidator(factory, data);
        }
        catch (JsonParseException exception) {
            throw INVALID_TX_DATA.create();
        }
        if (validator == null) {
            throw INVALID_TX_DATA.create();
        }
        return validator;
    }

    private static int noArgsProvided(String ... args) throws CommandSyntaxException {
        throw MISSING_ARGUMENTS.create((Object)(args.length > 0 ? String.join((CharSequence)",", args) : ""));
    }

    private static PlayerEntity getPlayer(CommandContext<CommandSource> ctx) {
        return (PlayerEntity)((CommandSource)ctx.getSource()).func_197022_f();
    }

    private static enum ModifyAction {
        LOCK(ILockStateChangeable::doLock),
        UNLOCK(ILockStateChangeable::doUnlock);

        final Consumer<ILockStateChangeable> action;

        private ModifyAction(Consumer<ILockStateChangeable> action) {
            this.action = action;
        }

        void apply(ILockStateChangeable skills) {
            this.action.accept(skills);
        }
    }
}

